<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug');
            $table->integer('number')->nullable();
            $table->tinyInteger('seller')->nullable();
            $table->string('activity' , 30)->nullable();
            $table->boolean('seen')->default(0);
            $table->boolean('admin')->default(0);
            $table->string('email')->unique();
            $table->string('geo')->nullable();
            $table->text('about')->nullable();
            $table->string('shaba' , 26)->nullable();
            $table->integer('landlinePhone')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->rememberToken();
            $table->foreignId('current_team_id')->nullable();
            $table->text('profile')->nullable();
            $table->text('profile_photo_path')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
