<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Link;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;

class LinkController extends Controller
{
    public function index(Request $request){
        $edits = 1;
        $deletes = 1;
        $adds = 1;
        $shows = 1;

        if($request->value){
            DB::table('links')->whereIn('id', $request->value)->delete();
        }
        if($request->name){
            $request->validate([
                'name' => 'required|max:220',
            ]);
            if($request->taxId){
                $tax = Link::where('id' , $request->taxId)->first();
                $tax->update([
                    'name'=> $request->name,
                    'address'=> $request->address,
                    'updated_at'=> Carbon::now(),
                ]);
            }else{
                $tax = Link::where('name' , $request->name)->first();
                if (!$tax){
                    $tax = Link::create([
                        'name'=> $request->name,
                        'address'=> $request->address,
                    ]);
                }
            }
        }
        if($request->taxId && !$request->name){
            $taxEdit = Link::where('id' , $request->taxId)->first();
            $categories = [];
        }else{
            $taxEdit = '';
            $categories = [];
        }


        if ($request->search){
            $search = Link::where("name" , "LIKE" , "%{$request->search}%")->pluck('id')->toArray();
            if(count($search) == 0){
                $search = Link::where("id" , "LIKE" , "%{$request->search}%")->pluck('id')->toArray();
            }
        }else{
            $search = Link::latest()->pluck('id')->toArray();
        }
        if ($request->date){
            $date = Link::whereDate('created_at',$request->date)->pluck('id')->toArray();
        }else{
            $date = Link::latest()->pluck('id')->toArray();
        }

        $arrayFilter = array_intersect($search,$date);
        $taxes = Link::latest()->whereIn('id' , $arrayFilter)->paginate(30);
        $taxesSend = [];
        $name='لینک';
        $routeAddress='link';
        $sidebar= '4';
        $labels = ['#','آیدی','نام','تاریخ ثبت','عملیات'];
        return Inertia::render('Taxonami/AllTaxonami' , [
            'name' => $name,
            'taxes' => $taxes,
            'categories'=> $categories,
            'taxesSend' => $taxesSend,
            'labels' => $labels,
            'adds' => $adds,
            'edits' => $edits,
            'deletes' => $deletes,
            'shows' => $shows,
            'taxEdit' => $taxEdit,
            'routeAddress' => $routeAddress,
            'sidebar' => $sidebar,
        ]);
    }
}
