<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Country;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Inertia\Inertia;

class CountryController extends Controller
{
    public function index(Request $request){
        $edits = 1;
        $deletes = 1;
        $adds = 1;
        $shows = 1;
        if($request->value){
            foreach ($request->value as $value) {
                $tax = Country::where('id', $value)->first();
                $tax->user()->detach();
                $tax->post()->detach();
            }
            DB::table('countries')->whereIn('id', $request->value)->delete();
        }
        if($request->name){
            $request->validate([
                'name' => 'required|max:220',
            ]);
            if($request->taxId){
                $tax = Country::where('id' , $request->taxId)->first();
                $tax->update([
                    'name'=> $request->name,
                    'slug'=> $request->slug,
                    'updated_at'=> Carbon::now(),
                ]);
            }else{
                $tax = Country::where('name' , $request->name)->first();
                if (!$tax){
                    $tax = Country::create([
                        'name'=> $request->name,
                        'slug'=> $request->slug,
                    ]);
                    auth()->user()->country()->sync($tax->id);
                }
            }
        }
        if($request->taxId && !$request->name){
            $taxEdit = Country::where('id' , $request->taxId)->first();
        }else{
            $taxEdit = '';
        }

        if ($request->search){
            $search = Country::where("name" , "LIKE" , "%{$request->search}%")->pluck('id')->toArray();
            if(count($search) == 0){
                $search = Country::where("id" , "LIKE" , "%{$request->search}%")->pluck('id')->toArray();
            }
        }else{
            $search = Country::latest()->pluck('id')->toArray();
        }
        if ($request->date){
            $date = Country::whereDate('created_at',$request->date)->pluck('id')->toArray();
        }else{
            $date = Country::latest()->pluck('id')->toArray();
        }

        $arrayFilter = array_intersect($search,$date);
        $taxes = Country::latest()->whereIn('id' , $arrayFilter)->paginate(30);
        $taxesSend = Country::latest()->pluck('name','id');
        $name='کشور';
        $routeAddress='country';
        $sidebar= '4';
        $labels = ['#','آیدی','نام','تاریخ ثبت','عملیات'];
        return Inertia::render('Taxonami/AllTaxonami' , [
            'name' => $name,
            'taxes' => $taxes,
            'taxesSend' => $taxesSend,
            'labels' => $labels,
            'adds' => $adds,
            'edits' => $edits,
            'deletes' => $deletes,
            'shows' => $shows,
            'taxEdit' => $taxEdit,
            'routeAddress' => $routeAddress,
            'sidebar' => $sidebar,
        ]);
    }
}
