<?php


namespace App\Traits;


use App\Models\Setting;
use Ghasedak\GhasedakApi;

trait SendSmsTrait
{
    public function sendSms($number,$message,$line){
        $smsType = Setting::where('key' , 'smsType')->pluck('value')->first();
        if($smsType == 0){
            $curl = curl_init();
            if(count($message) >= 2){
                curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://gateway.ghasedak.me/rest/api/v1/WebService/SendOtpWithParams',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => json_encode([
                        "date" => 0,
                        "receptors" => [
                            [
                                "mobile" => $number,
                                "clientReferenceId" => $number
                            ]
                        ],
                        "templateName" => "$line",
                        "param1" => "$message[0]",
                        "param2" => "$message[1]",
                        "isVoice" => false,
                        "udh" => true
                    ]),
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        'ApiKey: ' . env('GHASEDAKAPI_KEY'),
                    ),
                ));
            }else{
                curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://gateway.ghasedak.me/rest/api/v1/WebService/SendOtpWithParams',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => json_encode([
                        "date" => 0,
                        "receptors" => [
                            [
                                "mobile" => $number,
                                "clientReferenceId" => $number
                            ]
                        ],
                        "templateName" => "$line",
                        "param1" => "$message[0]",
                        "isVoice" => false,
                        "udh" => true
                    ]),
                    CURLOPT_HTTPHEADER => array(
                        'Content-Type: application/json',
                        'ApiKey: ' . env('GHASEDAKAPI_KEY'),
                    ),
                ));
            }
            $response = curl_exec($curl);
            if (curl_errno($curl)) {
                echo 'Curl error: ' . curl_error($curl);
            }

            curl_close($curl);
        }
        if($smsType == 1){
            $userSms = env('meli_user');
            $passSms = env('meli_password');
            $theme = env('meli_pattern');
            $text = implode(';',$message);
            $url = "https://api.payamak-panel.com/post/Send.asmx/SendByBaseNumber2?username=$userSms&password=$passSms&text=$text;&to=$number&bodyId=$theme";
            $client = new Client();
            $response = $client->request('GET', $url,
                [
                    'allow_redirects' => true
                ]);
            $contents = $response->getBody()->getContents();
            $contents = json_decode($contents,true);
        }
        if($smsType == 2){
            $kaveKey = env('kave_key');
            $theme = env('kave_pattern');
            $texts = [];
            for ( $i = 0; $i < count($message); $i++) {
                if($i == 0){
                    $check = 'token='.str_replace(' ', '', $message[$i]);
                }
                if($i == 1){
                    $check = 'token2='.str_replace(' ', '', $message[$i]);
                }
                if($i == 2){
                    $check = 'token3='.str_replace(' ', '', $message[$i]);
                }
                array_push($texts , $check);
            }
            $text = implode('&',$texts);
            $url = "https://api.kavenegar.com/v1/$kaveKey/verify/lookup.json?receptor=$number&$text&template=$theme";
            $client = new Client();
            $response = $client->request('GET', $url,
                [
                    'allow_redirects' => true
                ]);
            $contents = $response->getBody()->getContents();
            $contents = json_decode($contents,true);
        }
        if($smsType == 3){
            $input_data = [];
            if(count($message) == 1){
                $input_data = array('token' => $message[0]);
            }
            if(count($message) == 2){
                $input_data = array('token' => $message[0] , 'token2' => $message[1]);
            }
            if(count($message) == 3){
                $input_data = array('token' => $message[0] , 'token2' => $message[1] , 'token3' => $message[2]);
            }
            $theme = env('ippanel_pattern');
            $user = env('ippanel_user');
            $pass = env('ippanel_pass');
            $pass = env('ippanel_number');
            $toNum = array($number);
            $pattern_code = $theme;
            $url = 'https://ippanel.com/patterns/pattern?username=' . $user . '&password=' . urlencode($pass) . '&from='.$fromNum.'&to=' . json_encode($toNum) . '&input_data=' . urlencode(json_encode($input_data)) . '&pattern_code='.$pattern_code;
            $handler = curl_init($url);
            curl_setopt($handler, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($handler, CURLOPT_POSTFIELDS, json_encode($input_data));
            curl_setopt($handler, CURLOPT_RETURNTRANSFER, true);
            $response = curl_exec($handler);
        }
    }
}
