<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Models\Carrier;
use App\Models\Comment;
use App\Models\Event;
use App\Models\Gallery;
use App\Models\Pay;
use App\Models\Post;
use App\Models\Setting;
use App\Models\Ticket;
use App\Models\User;
use App\Models\UserMeta;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\SEOTools;
use Artesaos\SEOTools\Facades\TwitterCard;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Inertia\Inertia;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function profile(){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $body = Setting::where('key' , 'body')->pluck('value')->first();
        $address = Setting::where('key' , 'address')->pluck('value')->first();
        $keyword = Setting::where('key' , 'keyword')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first();
        OpenGraph::setDescription($body);
        OpenGraph::addProperty('locale', 'fa-ir');
        OpenGraph::setUrl($address);
        SEOTools::opengraph()->addProperty('type', 'stores');
        SEOMeta::addKeyword($keyword);
        OpenGraph::addImage($address.$logo);
        OpenGraph::setSiteName($title);
        TwitterCard::setTitle('حساب کاربری - ' . $title);
        TwitterCard::setDescription($body);
        TwitterCard::setUrl($address);
        TwitterCard::addImage($address.$logo);

        $pays = Pay::latest()->where('user_id' , auth()->user()->id)->take(10)->get();
        $likes =  auth()->user()->like;
        $like = [];
        foreach ($likes as $item) {
            $posts = Post::latest()->where('id' , $item->post_id)->first();
            array_push($like , $posts);
        }

        $bookmarks =  auth()->user()->bookmark;
        $bookmark = [];
        foreach ($bookmarks as $item) {
            $posts = Post::latest()->where('id' , $item->post_id)->first();
            array_push($bookmark , $posts);
        }
        return view('home.profile.index', compact('pays','bookmark','like'));
    }
    public function pay(Request $request){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $body = Setting::where('key' , 'body')->pluck('value')->first();
        $address = Setting::where('key' , 'address')->pluck('value')->first();
        $keyword = Setting::where('key' , 'keyword')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first();
        OpenGraph::setDescription($body);
        OpenGraph::addProperty('locale', 'fa-ir');
        OpenGraph::setUrl($address);
        SEOTools::opengraph()->addProperty('type', 'stores');
        SEOMeta::addKeyword($keyword);
        OpenGraph::addImage($address.$logo);
        OpenGraph::setSiteName($title);
        TwitterCard::setTitle('پرداختی ها - ' . $title);
        TwitterCard::setDescription($body);
        TwitterCard::setUrl($address);
        TwitterCard::addImage($address.$logo);
        $pays = Pay::latest()->where('user_id' , auth()->user()->id)->get();
        return view('home.profile.pay',compact('pays'));
    }
    public function bookmark(){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $body = Setting::where('key' , 'body')->pluck('value')->first();
        $address = Setting::where('key' , 'address')->pluck('value')->first();
        $keyword = Setting::where('key' , 'keyword')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first();
        OpenGraph::setDescription($body);
        OpenGraph::addProperty('locale', 'fa-ir');
        OpenGraph::setUrl($address);
        SEOTools::opengraph()->addProperty('type', 'stores');
        SEOMeta::addKeyword($keyword);
        OpenGraph::addImage($address.$logo);
        OpenGraph::setSiteName($title);
        TwitterCard::setTitle('نشانه ها - ' . $title);
        TwitterCard::setDescription($body);
        TwitterCard::setUrl($address);
        TwitterCard::addImage($address.$logo);
        $bookmarks =  auth()->user()->bookmark;
        $bookmarkData = [];
        foreach ($bookmarks as $item) {
            $posts = Post::latest()->where('id' , $item->post_id)->pluck('id')->first();
            array_push($bookmarkData , $posts);
        }
        $bookmark = Post::latest()->whereIn('id' , $bookmarkData)->get();
        $tab = 2;
        return view('home.profile.bookmark',compact('bookmark','tab'));
    }
    public function like(){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $body = Setting::where('key' , 'body')->pluck('value')->first();
        $address = Setting::where('key' , 'address')->pluck('value')->first();
        $keyword = Setting::where('key' , 'keyword')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first();
        OpenGraph::setDescription($body);
        OpenGraph::addProperty('locale', 'fa-ir');
        OpenGraph::setUrl($address);
        SEOTools::opengraph()->addProperty('type', 'stores');
        SEOMeta::addKeyword($keyword);
        OpenGraph::addImage($address.$logo);
        OpenGraph::setSiteName($title);
        TwitterCard::setTitle('علاقه مندی - ' . $title);
        TwitterCard::setDescription($body);
        TwitterCard::setUrl($address);
        TwitterCard::addImage($address.$logo);
        $likes =  auth()->user()->like;
        $likePost = [];
        foreach ($likes as $item) {
            $posts = Post::latest()->where('id' , $item->post_id)->pluck('id')->first();
            array_push($likePost , $posts);
        }
        $bookmark = Post::latest()->whereIn('id' , $likePost)->get();
        $tab = 3;
        return view('home.profile.bookmark',compact('bookmark','tab'));
    }
    public function comment(){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $body = Setting::where('key' , 'body')->pluck('value')->first();
        $address = Setting::where('key' , 'address')->pluck('value')->first();
        $keyword = Setting::where('key' , 'keyword')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first();
        OpenGraph::setDescription($body);
        OpenGraph::addProperty('locale', 'fa-ir');
        OpenGraph::setUrl($address);
        SEOTools::opengraph()->addProperty('type', 'stores');
        SEOMeta::addKeyword($keyword);
        OpenGraph::addImage($address.$logo);
        OpenGraph::setSiteName($title);
        TwitterCard::setTitle('دیدگاه ها - ' . $title);
        TwitterCard::setDescription($body);
        TwitterCard::setUrl($address);
        TwitterCard::addImage($address.$logo);
        $comments = Comment::where('user_id' , auth()->user()->id)->with('post')->get();
        return view('home.profile.comment',compact('comments'));
    }
    public function deleteComment(Request $request , Comment $comment){
        Comment::where('user_id' , auth()->user()->id)->where('id' , $comment->id)->first()->delete();
        return 'success';
    }
    public function deleteTicket(Request $request , Ticket $ticket){
        Ticket::where('user_id' , auth()->user()->id)->where('id' , $ticket->id)->first()->delete();
        return 'success';
    }
    public function ticket(Request $request){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $body = Setting::where('key' , 'body')->pluck('value')->first();
        $address = Setting::where('key' , 'address')->pluck('value')->first();
        $keyword = Setting::where('key' , 'keyword')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first();
        OpenGraph::setDescription($body);
        OpenGraph::addProperty('locale', 'fa-ir');
        OpenGraph::setUrl($address);
        SEOTools::opengraph()->addProperty('type', 'stores');
        SEOMeta::addKeyword($keyword);
        OpenGraph::addImage($address.$logo);
        OpenGraph::setSiteName($title);
        TwitterCard::setTitle('درخواست ها - ' . $title);
        TwitterCard::setDescription($body);
        TwitterCard::setUrl($address);
        TwitterCard::addImage($address.$logo);
        $tickets = Ticket::where('user_id' , auth()->user()->id)->get();
        return view('home.profile.ticket',compact('tickets'));
    }
    public function personalInfo(){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $body = Setting::where('key' , 'body')->pluck('value')->first();
        $address = Setting::where('key' , 'address')->pluck('value')->first();
        $keyword = Setting::where('key' , 'keyword')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first();
        OpenGraph::setDescription($body);
        OpenGraph::addProperty('locale', 'fa-ir');
        OpenGraph::setUrl($address);
        SEOTools::opengraph()->addProperty('type', 'stores');
        SEOMeta::addKeyword($keyword);
        OpenGraph::addImage($address.$logo);
        OpenGraph::setSiteName($title);
        TwitterCard::setTitle('اطلاعات شخصی - ' . $title);
        TwitterCard::setDescription($body);
        TwitterCard::setUrl($address);
        TwitterCard::addImage($address.$logo);
        $map = Setting::where('key' , 'map')->pluck('value')->first();
        return view('home.profile.info',compact('map'));
    }
    public function ChangeAllUserInfo(User $user , Request $request){
        $request->validate([
            'user' => 'required|max:255',
        ]);
        $users = User::where('id' , auth()->user()->id)->first();
        $check = $users->userMeta()->count();
        $geo=[
            'lng'=> $request->geo[0],
            'lat'=> $request->geo[1],
        ];
        if ($check >= 1){
            if($request->password){
                $users->update([
                    'password'=>Hash::make($request->password),
                    'name'=>$request->user,
                    'landlinePhone'=>$request->landlinePhone,
                    'shaba'=>$request->shaba,
                    'about'=>$request->about,
                    'geo'=> json_encode($geo),
                ]);
                Event::create([
                    'type' => 9,
                    'title' => 'تغییر رمز',
                    'user_id' => auth()->user()->id,
                    'description' => 'کاربر با نام ' . auth()->user()->name . 'رمز خود را عوض کرد',
                ]);
            }else{
                $users->update([
                    'name'=>$request->user,
                    'landlinePhone'=>$request->landlinePhone,
                    'shaba'=>$request->shaba,
                    'about'=>$request->about,
                    'geo'=> json_encode($geo),
                ]);
            }
            $users->userMeta()->update([
                'date'=>$request->date,
                'name'=>$request->name,
                'post'=>$request->post,
                'job'=>$request->job,
                'code'=>$request->code,
                'address'=>$request->address,
            ]);
            Event::create([
                'type' => 11,
                'title' => 'تغییر اطلاعات کاربر',
                'user_id' => auth()->user()->id,
                'description' => 'کاربر با نام ' . auth()->user()->name . 'اطلاعات خود را تغییر داد',
            ]);
            return 'success';
        }
        else{
            if($request->password){
                $users->update([
                    'number'=>$request->number,
                    'email'=>$request->email,
                    'password'=>Hash::make($request->password),
                    'name'=>$request->user,
                    'about'=>$request->about,
                    'geo'=> json_encode($geo),
                ]);
            }else{
                $users->update([
                    'number'=>$request->number,
                    'email'=>$request->email,
                    'about'=>$request->about,
                    'geo'=> json_encode($geo),
                    'name'=>$request->user,
                ]);
            }
            $userMeta = UserMeta::create([
                'date'=>$request->date,
                'name'=>$request->name,
                'post'=>$request->post,
                'job'=>$request->job,
                'code'=>$request->code,
                'address'=>$request->address,
            ]);
            Event::create([
                'type' => 11,
                'title' => 'تغییر اطلاعات کاربر',
                'user_id' => auth()->user()->id,
                'description' => 'کاربر با نام ' . auth()->user()->name . 'اطلاعات خود را تغییر داد',
            ]);
            $users->userMeta()->sync($userMeta->id);
            return 'success';
        }
    }
    public function createImage(Request $request){
        $year = Carbon::now()->year;
        $folder = public_path('upload/document/' . $year . '/' . auth()->user()->id . '/');
        if (!file_exists($folder)){
            mkdir($folder , 0755 , true);
        }
        $file = $request->file;
        $name = $file->getClientOriginalName();
        $type = $file->getClientOriginalExtension();
        $sizefile = $file->getsize()/1000;
        if( $sizefile > 1000){
            $size=round($sizefile/1000 ,2) . 'mb';
        }else{
            $size=round($sizefile) . 'kb';
        }
        if ($type == "jpg" or $type == "JPG" or $type == "png" or $type == "jpeg" or $type == "svg" or $type == "tif" or $type == "gif" or $type == "jfif"){
            $url = "/upload/document/" . $year . '/' . auth()->user()->id;
            $path = $file->move($_SERVER['DOCUMENT_ROOT'] .$url , time() . '.' . $type);
            $gallery = Gallery::create([
                'name' => $name,
                'size' => $size,
                'type' => $type,
                'user_id' => auth()->user()->id,
                'url' => $url . '/' . time() . '.' . $type,
                'path' => $path->getRealPath(),
            ]);
            return $gallery;
        }else{
            return 'format';
        }
    }
    public function changeProfile(Request $request){
        $year = Carbon::now()->year;
        $folder = public_path('upload/document/' . $year . '/' . auth()->user()->id . '/');
        if (!file_exists($folder)){
            mkdir($folder , 0755 , true);
        }
        $file = $request->file;
        $name = $file->getClientOriginalName();
        $type = $file->getClientOriginalExtension();
        $sizefile = $file->getsize()/1000;
        if( $sizefile > 1000){
            $size=round($sizefile/1000 ,2) . 'mb';
        }else{
            $size=round($sizefile) . 'kb';
        }
        if ($type == "jpg" or $type == "JPG" or $type == "png" or $type == "jpeg" or $type == "svg" or $type == "tif" or $type == "gif" or $type == "jfif"){
            $url = "/upload/document/" . $year . '/' . auth()->user()->id;
            $path = $file->move($_SERVER['DOCUMENT_ROOT'] .$url , time() . '.' . $type);
            $gallery = Gallery::create([
                'name' => $name,
                'size' => $size,
                'type' => $type,
                'user_id' => auth()->user()->id,
                'url' => $url . '/' . time() . '.' . $type,
                'path' => $path->getRealPath(),
            ]);
            auth()->user()->update([
                'profile' => $gallery->url
            ]);
            return $gallery;
        }else{
            return 'format';
        }
    }
    public function showPay(Pay $pay){
        if(auth()->user()){
            $pays = Pay::where('id' , $pay->id)->with('carrier','address')->with(["user" => function($q){
                $q->with('userMeta');
            }])->with(["payMeta" => function($q){
                $q->with('post','guarantee');
            }])->first();
            return view('home.profile.showPay' , compact('pays'));
        }else{
            return abort(404);
        }
    }
    public function invoice(Pay $pay){
        if(auth()->user()){
            if ($pay->user_id == auth()->user()->id){
                $carrier = Carrier::with(["pay" => function ($q) use ($pay){
                    $q->where('id',$pay->id);
                }])->get();
                $title = Setting::where('key' , 'title')->pluck('value')->first();
                $logo = Setting::where('key' , 'logo')->pluck('value')->first();
                $address = Setting::where('key' , 'address')->pluck('value')->first();
                $email = Setting::where('key' , 'email')->pluck('value')->first();
                $number = Setting::where('key' , 'number')->pluck('value')->first();
                $pays = Pay::with('carrier','address')->where('id',$pay->id)->with(["payMeta" => function($q){
                    $q->with('guarantee','discount')->with(["post" => function($q){
                        $q->with('user');
                    }]);
                }])->with(["user" => function($q){
                    $q->with('userMeta');
                }])->first();
                return view('home.profile.invoice' , compact('pays','title','number','email','address','logo','carrier'));
            }else{
                return abort(404);
            }
        }else{
            return abort(404);
        }
    }
}
