<?php

namespace App\Http\Controllers\Home;

use App\Http\Controllers\Controller;
use App\Models\Ask;
use App\Models\Event;
use App\Models\Ticket;
use Illuminate\Http\Request;

class TicketController extends Controller
{
    public function index() {
        $asks = Ask::get();
        return view('home.ticket.index',compact('asks'));
    }
    public function sendTicket(Request $request){
        if (auth()->user()){
            Ticket::create([
                'body' => $request->ticket,
                'name' => $request->name,
                'email' => $request->email,
                'file' => $request->file,
                'user_id' => auth()->user()->id,
            ]);
            Event::create([
                'type' => 8,
                'title' => 'تیکت',
                'user_id' => auth()->user()->id,
                'description' => 'کاربر با نام ' . auth()->user()->name . 'تیکتی ارسال کرد',
            ]);
            return 'success';
        }else{
            return 'noUser';
        }
    }
}
