<?php

namespace App\Http\Controllers\Home;

use App\Models\Cart;
use App\Models\Event;
use App\Models\Gallery;
use App\Traits\SeoHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\ProductResource;
use App\Models\Brand;
use App\Models\Category;
use App\Models\News;
use App\Models\Page;
use App\Models\Pay;
use App\Models\Post;
use App\Models\Robot;
use App\Models\Setting;
use App\Models\Ticket;
use App\Models\Vidget;
use App\Models\View;
use Carbon\Carbon;
use App\Models\User;
use Hekmatinasser\Verta\Verta;
use Illuminate\Http\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cache;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Artesaos\SEOTools\Facades\OpenGraph;
use Artesaos\SEOTools\Facades\SEOMeta;
use Artesaos\SEOTools\Facades\TwitterCard;
use Artesaos\SEOTools\Facades\SEOTools;
use Inertia\Inertia;
use Jenssegers\Agent\Agent;

class IndexController extends Controller
{
    use SeoHelper;
    public function index(){
        $this->setIndexSeo();
        $widgets = Vidget::where('platform' , 0)->get();
        $widget = [];
        foreach ($widgets as $item){
            $widgetCategory = [
                'name'=> $item['name'],
                'title'=> $item['title'],
                'more'=> $item['more'],
                'titleEn'=> $item['titleEn'],
                'moreEn'=> $item['moreEn'],
                'slug'=> $item['slug'],
                'background'=> $item['background'],
                'show'=> $item['show'],
                'type'=> $item['type'],
                'count'=> $item['count'],
                'post'=> [],
                'pay'=> [],
            ];
            if($item['name'] != 'تبلیغات ساده' && $item['name'] != 'خبر ها' && $item['name'] != 'دسته بندی دلخواه' && $item['name'] != 'تبلیغات اسلایدری'){
                $ids = [];
                $ids2 = [];
                if($item['category'] != ''){
                    $allCatSite3 = explode(',' , $item['category']);
                    foreach ($allCatSite3 as $value){
                        $tax = Category::where('name' , $value)->where('type' , 0)->first();
                        if($tax){
                            $send2 = $tax->post()->pluck('id')->toArray();
                            foreach ($send2 as $data){
                                array_push($ids ,$data);
                            }
                        }
                    }
                }
                if($item['brand'] != ''){
                    $allBrandSite3 = explode(',' , $item['brand']);
                    foreach ($allBrandSite3 as $value){
                        $tax = Brand::where('name' , $value)->first();
                        if($tax){
                            $send2 = $tax->post()->pluck('id')->toArray();
                            foreach ($send2 as $data){
                                array_push($ids2 ,$data);
                            }
                        }
                    }
                }
                if($ids && $ids2){
                    $arrayFilter = array_intersect($ids2, $ids);
                }else{
                    if($ids){
                        $arrayFilter = $ids;
                    }elseif($ids2){
                        $arrayFilter = $ids;
                    }else{
                        $arrayFilter = Post::where('status' , 1)->where('variety' , 0)->take($item['count'])->pluck('id');
                    }
                }
                if ($item['show'] == 0){
                    if($item['type'] == 3){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('type' , 0)->where('variety' , 0)->latest()->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 0){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->latest()->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 1){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->latest()->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 2){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->latest()->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                }
                if ($item['show'] == 1 or $item['show'] == 2){
                    if($item['type'] == 3){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->withCount('view')->orderBy('view_count','DESC' )->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 0){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->withCount('view')->orderBy('view_count','DESC' )->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 1){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->withCount('view')->orderBy('view_count','DESC' )->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 2){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->withCount('view')->orderBy('view_count','DESC' )->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                }
                if ($item['show'] == 3){
                    if($item['type'] == 3){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('variety' , 0)->orderBy('price')->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 0){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->orderBy('price')->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 1){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->orderBy('price')->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 2){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->orderBy('price')->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                }
                if ($item['show'] == 4){
                    if($item['type'] == 3){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->orderBy('price','DESC')->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 0){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->orderBy('price','DESC')->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 1){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->orderBy('price','DESC')->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 2){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->orderBy('price','DESC')->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                }
                if ($item['show'] == 5){
                    if($item['type'] == 3){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 0){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('count' , '>=' , 1)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 1){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('off' , '!=' , null)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                    if($item['type'] == 2){
                        $catPost1 = Post::whereIn('id' , $arrayFilter)->where('type' , 0)->where('variety' , 0)->where('suggest' , '!=' , null)->withCount('payMeta')->orderBy('pay_meta_count','DESC' )->where('status' , 1)->take($item['count'])->with('review')->withCount(["rate" => function ($q) {
                            $q->select(DB::raw('round(avg(rate_post),1)'));
                        }])->get();
                        $catPost = ProductResource::collection($catPost1);
                    }
                }
                $widgetCategory['post'] = $catPost;
            }
            if($item['name'] == 'تبلیغات ساده'){
                $widgetCategory['post'] = [];
                $widgetCategory['post'] = $item['brand'];
            }
            if($item['name'] == 'دسته بندی دلخواه'){
                $widgetCategory['post'] = [];
                $widgetCategory['post'] = $item['brand'];
            }
            if($item['name'] == 'تبلیغات اسلایدری'){
                $widgetCategory['post'] = [];
                $widgetCategory['title'] = [];
                $widgetCategory['post'] = $item['brand'];
                $widgetCategory['title'] = $item['category'];
            }
            if($item['name'] == 'خبر ها'){
                $widgetCategory['post'] = [];
                if($item['category'] != ''){
                    $allCatSite3 = explode(',' , $item['category']);
                    foreach ($allCatSite3 as $value){
                        $tax = Category::where('name' , $value)->where('type' , 1)->first();
                        if($tax){
                            $send2 = $tax->news()->pluck('id')->toArray();
                            foreach ($send2 as $data){
                                array_push($ids ,$data);
                            }
                        }
                    }
                }else{
                    $ids = News::take($item['count'])->latest()->pluck('id')->toArray();
                }
                $catPost = News::latest()->whereIn('id' , $ids)->where('status' , 1)->take($item['count'])->with('category','user')->get();
                $widgetCategory['post'] = $catPost;
            }
            array_push($widget , $widgetCategory);
        }
        $time= Setting::where('key' , 'timePop')->pluck('value')->first();
        $image= Setting::where('key' , 'imagePop')->pluck('value')->first();
        $description= Setting::where('key' , 'descriptionPop')->pluck('value')->first();
        $title= Setting::where('key' , 'titlePop')->pluck('value')->first();
        $button= Setting::where('key' , 'buttonPop')->pluck('value')->first();
        $color= Setting::where('key' , 'colorPop')->pluck('value')->first();
        $colorbutton= Setting::where('key' , 'colorButtonPop')->pluck('value')->first();
        $logo= Setting::where('key' , 'logo')->pluck('value')->first();
        $names= Setting::where('key' , 'name')->pluck('value')->first();
        $agent = new Agent();
        $platform = $agent->platform();
        if($platform == 'iOS'){
            $platform = 'ios';
        }
        elseif($platform == 'AndroidOS'){
            $platform = 'android';
        }
        $sizes1 = json_decode(Setting::where('key' , 'sizes')->pluck('value')->first())??[];
        $colors1 = json_decode(Setting::where('key' , 'colors')->pluck('value')->first())??[];
        $materials1 = json_decode(Setting::where('key' , 'materials')->pluck('value')->first())??[];
        $types1 = json_decode(Setting::where('key' , 'types')->pluck('value')->first())??[];
        return view('home.index' , compact('widget','platform','sizes1','colors1','materials1','types1','names','logo','time','image','description','title','button','color','colorbutton'));
    }

    public function page(Page $page){
        $title = Setting::where('key' , 'title')->pluck('value')->first();
        $email = Setting::where('key' , 'email')->pluck('value')->first();
        $logo = Setting::where('key' , 'logo')->pluck('value')->first() ?:'' ;
        $number = Setting::where('key' , 'number')->pluck('value')->first();
        $about = Setting::where('key' , 'about')->pluck('value')->first();
        $map = Setting::where('key' , 'map')->pluck('value')->first();
        $this->seoSingleSeo(   $page->title . " - $title " , $page->body , 'store' , "$page->slug" , $logo );
        return view('home.page.index',compact('page','email','number','about','map'));
    }

    public function showCompares(Request $request){
        $postsItem =[];
        foreach ($request->postCompare as $posts) {
            $send = Post::where('id' , $posts)->with('review')->first();
            array_push($postsItem ,$send);
        }
        return $postsItem;
    }

    public function uploadImage(Request $request){
        $year = Carbon::now()->year;
        $folder = public_path('upload/image/' . $year . '/');
        if (!file_exists($folder)){
            mkdir($folder , 0755 , true);
        }
        $file = $request->file;
        $type = $file->getClientOriginalExtension();
        $name = time().rand(0,10).'.'.$type;
        $sizefile = $file->getsize()/1000;
        if( $sizefile > 1000){
            $size=round($sizefile/1000 ,2) . 'mb';
        }else{
            $size=round($sizefile) . 'kb';
        }
        if ($type == "jpg" or $type == "webp" or $type == "WEBP" or $type == "JPG" or $type == "png" or $type == "jpeg" or $type == "svg" or $type == "tif" or $type == "gif" or $type == "jfif"){
            $url = "/upload/image/" . $year;
            $path = $file->move($_SERVER['DOCUMENT_ROOT'] .$url , $name);
            $img = Gallery::create([
                'name' => $name,
                'size' => $size,
                'type' => $type,
                'user_id' => auth()->user()?auth()->user()->id:User::value('id'),
                'url' => $url . '/' . $name ,
                'path' => $path->getRealPath(),
            ]);
            return $img->url;
        }
        return '';
    }

    public function sendDesign(Request $request){
        $price = 0;
        if($request->colors){
            $price += json_decode($request->colors)->price;
        }
        if($request->sizes){
            $price += json_decode($request->sizes)->price;
        }
        if($request->types){
            $price += json_decode($request->types)->price;
        }
        if($request->materials){
            $price += json_decode($request->materials)->price;
        }
        if (auth()->user()) {
            Cart::create([
                'post_id' => 0,
                'user_id' => auth()->user()->id,
                'guarantee_id' => $request->image,
                'color' => $request->colors,
                'size' => $request->sizes,
                'colorN' => $request->types,
                'sizeN' => $request->materials,
                'price' => $price,
                'count' => 1,
            ]);
        } else {
            $myCart = $request->cookie('myCart');
            if(!empty($myCart)){
                if ($myCart){
                    $changeCart = [];
                    foreach(json_decode($myCart , true) as $item) {
                        array_push($changeCart, $item);
                    }
                    $c = collect($changeCart);
                    $cart=[
                        'id' => 0,
                        'count' => 1,
                        'color' => $request->colors,
                        'size' => $request->sizes,
                        'colorN' => $request->types,
                        'sizeN' => $request->materials,
                        'guarantee_id' => $request->image,
                        'price' => $price,
                    ];
                    array_push($changeCart, $cart);
                    $response = new Response('success');
                    return $response->withCookie(cookie('myCart', json_encode($changeCart), 500));
                }else{
                    $cart=[
                        'id' => 0,
                        'count' => 1,
                        'color' => $request->colors,
                        'size' => $request->sizes,
                        'colorN' => $request->types,
                        'sizeN' => $request->materials,
                        'guarantee_id' => $request->image,
                        'price' => $price,
                    ];
                    $response = new Response('success');
                    return $response->withCookie(cookie('myCart', json_encode([$cart]) , 500));
                }
            }else{
                $cart=[
                    'id' => 0,
                    'count' => 1,
                    'color' => $request->colors,
                    'size' => $request->sizes,
                    'colorN' => $request->types,
                    'sizeN' => $request->materials,
                    'guarantee_id' => $request->image,
                    'price' => $price,
                ];
                $response = new Response('success');
                return $response->withCookie(cookie('myCart', json_encode([$cart]) , 500));
            }
        }
    }
}
