<?php

namespace App\Http\Controllers\Admin;

use App\Exports\CommentExport;
use App\Exports\EventExport;
use App\Exports\NewsExport;
use App\Exports\PayExport;
use App\Exports\PayMetaExport;
use App\Exports\PostExport;
use App\Exports\TicketExport;
use App\Exports\UserExport;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Inertia\Inertia;
use Maatwebsite\Excel\Facades\Excel;

class ExcelController extends Controller
{
    public function index(){
        return Inertia::render('Excel/ExcelPanel');
    }
    public function getExcel($data , Request $request){
        if($data == 'allUser'){
            return Excel::download(new UserExport('allUser' , 0), 'users.xlsx');
        }
        if($data == 'todayUser'){
            return Excel::download(new UserExport('todayUser' , 0), 'todayUsers.xlsx');
        }
        if($data == 'seller'){
            return Excel::download(new UserExport('seller' , $request->seller), 'seller.xlsx');
        }
        if($data == 'pay'){
            return Excel::download(new PayExport('pay' , $request->pay), 'pay.xlsx');
        }
        if($data == 'allPay'){
            return Excel::download(new PayExport('allPay' , 0), 'pays.xlsx');
        }
        if($data == 'todayPay'){
            return Excel::download(new PayExport('todayPay' , 0), 'todayPays.xlsx');
        }
        if($data == 'allPayMeta'){
            return Excel::download(new PayMetaExport('allPayMeta' , 0), 'payMetas.xlsx');
        }
        if($data == 'todayPayMeta'){
            return Excel::download(new PayMetaExport('todayPayMeta' , 0), 'todayPayMetas.xlsx');
        }
        if($data == 'allProduct'){
            return Excel::download(new PostExport('allProduct' , 0), 'products.xlsx');
        }
        if($data == 'todayProduct'){
            return Excel::download(new PostExport('todayProduct' , 0), 'todayProducts.xlsx');
        }
        if($data == 'allComment'){
            return Excel::download(new CommentExport('allComment' , 0), 'comments.xlsx');
        }
        if($data == 'todayComment'){
            return Excel::download(new CommentExport('todayComment' , 0), 'todayComment.xlsx');
        }
        if($data == 'allTicket'){
            return Excel::download(new TicketExport('allTicket' , 0), 'tickets.xlsx');
        }
        if($data == 'todayTicket'){
            return Excel::download(new TicketExport('todayTicket' , 0), 'todayTicket.xlsx');
        }
        if($data == 'allNews'){
            return Excel::download(new NewsExport('allNews' , 0), 'news.xlsx');
        }
        if($data == 'todayNews'){
            return Excel::download(new NewsExport('todayNews' , 0), 'todayNews.xlsx');
        }
        if($data == 'allEvent'){
            return Excel::download(new EventExport('allEvent' , 0), 'events.xlsx');
        }
        if($data == 'todayEvent'){
            return Excel::download(new EventExport('todayEvent' , 0), 'todayEvents.xlsx');
        }
    }
}
